
<?php $__env->startSection('content'); ?>
    <div class="contentfluid py-4">
    <div class="col-md-12"><h3 style="text-align: center"><?php echo e(__('messages.TABLEAU DE BORD')); ?></h3></div>
    <div class="row">
        <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
            <div class="card">
                <div class="card-header p-3 pt-2">
                    <div
                        class="icon icon-lg icon-shape bg-gradient-dark shadow-dark text-center border-radius-xl mt-n4 position-absolute">
                        <i class="btn" style="background-color: #08588d;color:#fff"><?php echo e(__('messages.Recette du mois en cours')); ?></i>
                    </div>
                    <div class="text-end pt-1">
                        <p class="text-sm mb-0 text-capitalize">&nbsp;</p>
                        <h5 class="mb-0"><?php echo e(number_format($recette,0,'.',' ')); ?> Franc cfa</h5><p>&nbsp;</p>
                    </div>
                </div>
                <hr class="dark horizontal my-0">
            </div>
        </div>
        <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
            <div class="card">
                <div class="card-header p-3 pt-2">
                    <div
                        class="icon icon-lg icon-shape bg-gradient-primary shadow-primary text-center border-radius-xl mt-n4 position-absolute">
                        <i class="btn" style="background-color: #e92676;color:#fff "><?php echo e(__('messages.Commande en attente')); ?></i>
                    </div>
                    <div class="alert alert-danger mt-3">
                        <h5><?php echo e($commande); ?> <?php echo e(__('messages.commande(s)')); ?></h5>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
            <div class="card">
                <div class="card-header p-3 pt-2">
                    <div
                        class="icon icon-lg icon-shape bg-gradient-success shadow-success text-center border-radius-xl mt-n4 position-absolute">
                        <i class="btn" style="background-color: #d1d73f;color:#fff"><?php echo e(__('messages.Produit en peremption')); ?></i>
                    </div>
                    <div class="text-end pt-1">
                        <p class="text-sm mb-0 text-capitalize">&nbsp;</p>
                        <h5 class="mb-0"><?php echo e($produit_perime); ?> <?php echo e(__('messages.produit(s)')); ?></h5><p>&nbsp;</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6">
            <div class="card">
                <div class="card-header p-3 pt-2">
                    <div
                        class="icon icon-lg icon-shape bg-gradient-info shadow-info text-center border-radius-xl mt-n4 position-absolute">
                        <i class="btn" style="background-color: #000000;color:#fff"><?php echo e(__('messages.Stock de securite atteint')); ?></i>
                    </div>
                    <div class="text-end pt-1">
                        <p class="text-sm mb-0 text-capitalize">&nbsp;</p>
                        <h5 class="mb-0"><?php echo e($stock_alerte); ?> <?php echo e(__('messages.produit(s)')); ?></h5><p>&nbsp;</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
        <div class="container-fluid col-md-12">
                <div id="lesventes" style="height: 400px; width: 100%;" ></div>
        </div>
        <div class="container-fluid col-md-12">
            <div id="stock" style="height: 400px;" ></div>
        </div>
        <br>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>

    <script>
        $(document).ready(function() {
            // Javascript method's body can be found in assets/js/demos.js
            //md.initDashboardPageCharts();
        });
    </script>
    <script type="text/javascript" src="<?php echo e(asset('js/googlePie.js')); ?>"></script>
    <script src="<?php echo e(asset('js/materialize.min.js')); ?>"></script>
    <script type="text/javascript">

        google.charts.load('current', {'packages':['bar']});
        google.charts.setOnLoadCallback(drawChart);
        google.charts.setOnLoadCallback(stock);

        google.charts.load('current', {'packages':['corechart']});
        google.charts.setOnLoadCallback(perimes);

        function drawChart() {

            var data = google.visualization.arrayToDataTable([
                ['Date', 'Ventes'],
                <?php $__currentLoopData = $ventes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> // On parcourt les catégories
                [ "<?php echo e($vente->date_vente); ?>", <?php echo e($vente->montant_total); ?> ], // Proportion des produits de la catégorie
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]);

            var options = {
                chart: {
                    title: '<?php echo e(__('messages.Les Ventes de l utilisateur du mois en cours')); ?>',
                },
                bars: 'vertical' // Direction "verticale" pour les bars
            };

            var chart = new google.charts.Bar(document.getElementById('lesventes'));

            chart.draw(data, google.charts.Bar.convertOptions(options));
        }

        function stock() {

            var data = google.visualization.arrayToDataTable([
                ['Produit', 'stock'],
                <?php $__currentLoopData = $stock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pdt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> // On parcourt les catégories
                [ "<?php echo e($pdt->libelle); ?>", <?php echo e($pdt->qte); ?> ], // Proportion des produits de la catégorie
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]);
            var options = {
                chart: {
                    title: '<?php echo e(__('messages.Les produits en fin de stock')); ?>',
                },
                bars: 'vertical' // Direction "verticale" pour les bars
            };

            var chart = new google.charts.Bar(document.getElementById('stock'));

            chart.draw(data, google.charts.Bar.convertOptions(options));
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\APP\gas\resources\views/layouts/admin.blade.php ENDPATH**/ ?>